/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.statistics.VWSIMQueueStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMQueueStatTableModel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsTableCellRenderer;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWSIMQueueStatTable
extends VWTable {
    protected Frame m_parentFrame = null;
    private VWSIMQueueStatPanel m_queueStatPanel = null;
    private boolean m_initialized = false;
    protected VWSIMQueueStatTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    private VWSIMStatisticsTableCellRenderer m_renderer = null;
    protected TableColumnModel m_columnModel = null;
    private boolean m_tabSelected = false;

    public VWSIMQueueStatTable(Frame parentFrame, VWSIMQueueStatTableModel tableModel) {
        this(parentFrame, null, tableModel);
    }

    public VWSIMQueueStatTable(Frame parentFrame, VWSIMQueueStatPanel queueStatPanel, VWSIMQueueStatTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_queueStatPanel = queueStatPanel;
        this.m_tableModel = tableModel;
        this.init();
    }

    public VWSIMQueueStatTable(Frame parentFrame, VWTableSorter tableSorter) {
        this(parentFrame, null, tableSorter);
    }

    public VWSIMQueueStatTable(Frame parentFrame, VWSIMQueueStatPanel queueStatPanel, VWTableSorter tableSorter) {
        super(tableSorter);
        this.m_parentFrame = parentFrame;
        this.m_queueStatPanel = queueStatPanel;
        TableModel tm = null;
        this.m_tableSorter = tableSorter;
        tm = tableSorter.getModel();
        if (tm != null && tm instanceof VWSIMQueueStatTableModel) {
            this.m_tableModel = (VWSIMQueueStatTableModel)tm;
        }
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    private void init() {
        this.m_columnModel = this.getColumnModel();
        this.m_renderer = new VWSIMStatisticsTableCellRenderer();
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            if (this.m_tableModel != null) {
                TableColumn nameColumn = this.m_columnModel.getColumn(0);
                nameColumn.setCellRenderer(this.m_renderer);
                int width = this.getMaxStringWidth(fm, VWSIMResource.s_queue_col, 0);
                if (width != 0) {
                    nameColumn.setMaxWidth(width += 10);
                    nameColumn.setPreferredWidth(width);
                }
                TableColumn activeColumn = this.m_columnModel.getColumn(1);
                activeColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_active_col);
                if (width != 0) {
                    activeColumn.setPreferredWidth(width += 10);
                }
                TableColumn completedColumn = this.m_columnModel.getColumn(2);
                completedColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_completed_col);
                if (width != 0) {
                    completedColumn.setPreferredWidth(width += 10);
                }
                TableColumn costColumn = this.m_columnModel.getColumn(3);
                costColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_cost_col);
                if (width != 0) {
                    costColumn.setPreferredWidth(width += 10);
                }
                TableColumn aveCostColumn = this.m_columnModel.getColumn(4);
                aveCostColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_average_cost_col);
                if (width != 0) {
                    aveCostColumn.setPreferredWidth(width += 10);
                }
                TableColumn overdueColumn = this.m_columnModel.getColumn(5);
                overdueColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_overdue_col);
                if (width != 0) {
                    overdueColumn.setPreferredWidth(width += 10);
                }
            }
        }
        this.m_initialized = true;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    VWSIMAnimatorDataModel getDataModel() {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getDataModel();
        }
        return null;
    }

    void tabSelected(boolean selected) {
        this.m_tabSelected = selected;
    }

    private int getMaxStringWidth(FontMetrics fm, String header, int col) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (header != null) {
            width = fm.stringWidth(header);
        }
        if (this.m_tableModel != null) {
            String str = null;
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                int w;
                Object obj = this.m_tableModel.getValueAt(i, col);
                if (obj == null || !(obj instanceof String) || (str = (String)obj) == null || str.length() <= 0 || (w = fm.stringWidth(str)) <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int getStringWidth(FontMetrics fm, String str) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (str != null) {
            width = fm.stringWidth(str);
        }
        return width;
    }

    void releaseResources() {
        this.m_parentFrame = null;
        this.m_queueStatPanel = null;
        this.m_tableSorter = null;
        if (this.m_tableModel != null && this.m_columnModel != null) {
            int columnCount = this.m_tableModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.m_columnModel.getColumn(i).setCellRenderer(null);
            }
        }
        this.m_renderer = null;
        this.m_columnModel = null;
        this.m_tableModel = null;
        this.removeAll();
    }
}

